unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ColorGrd, Buttons, Icon, Menus,
  ShellApi, Clipbrd, IniFiles, About;

const
  DefaultWidth = 383;
  DefaultHeight = 388;

var
  Imported : boolean;
  
type
  TMainForm = class(TForm)
    ToolPanel: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    OpenDialog1: TOpenDialog;
    New1: TMenuItem;
    Save: TMenuItem;
    SaveAs: TMenuItem;
    Exit1: TMenuItem;
    SaveDialog1: TSaveDialog;
    CaptureSpeedButton: TSpeedButton;
    PencilSpeedButton: TSpeedButton;
    TransparentPanel: TPanel;
    ReversePanel: TPanel;
    Panel0: TPanel;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Panel9: TPanel;
    Panel10: TPanel;
    Panel11: TPanel;
    Panel12: TPanel;
    Panel13: TPanel;
    Panel14: TPanel;
    Panel15: TPanel;
    LeftButtonPanel: TPanel;
    RightButtonPanel: TPanel;
    Close1: TMenuItem;
    CloseAll1: TMenuItem;
    Edit1: TMenuItem;
    Undo: TMenuItem;
    N2: TMenuItem;
    Cut: TMenuItem;
    Copy: TMenuItem;
    Paste: TMenuItem;
    SelectAll: TMenuItem;
    Help1: TMenuItem;
    Topics: TMenuItem;
    About1: TMenuItem;
    Window1: TMenuItem;
    Cascade1: TMenuItem;
    Tile1: TMenuItem;
    FillSpeedButton: TSpeedButton;
    LineSpeedButton: TSpeedButton;
    ClearRectangleSpeedButton: TSpeedButton;
    FilledRectangleSpeedButton: TSpeedButton;
    ClearEllipseSpeedButton: TSpeedButton;
    FilledEllipseSpeedButton: TSpeedButton;
    N3: TMenuItem;
    ShowPixels: TMenuItem;
    NewSpeedButton: TSpeedButton;
    SaveSpeedButton: TSpeedButton;
    TestIcon: TMenuItem;
    Icon1: TMenuItem;
    procedure ReadIni;
    procedure WriteIni;
    procedure SaveSpeedButtonClick(Sender: TObject);
    function  ReadIconFromFile(OpenName, FileName,
      IconName : string; ANewIcon : boolean) : boolean;
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure SaveAsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Panel0MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TopicsClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure CaptureSpeedButtonClick(Sender: TObject);
    function  Read16BitIcons(P : pchar) : boolean;
    procedure Import(FileName : TFileName);
    procedure UpdateTool;
    procedure UpdateButtons;
    procedure File1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure UndoClick(Sender: TObject);
    procedure CutClick(Sender: TObject);
    procedure CopyClick(Sender: TObject);
    procedure PasteClick(Sender: TObject);
    procedure SelectAllClick(Sender: TObject);
    procedure ShowPixelsClick(Sender: TObject);
    procedure TestIconClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    NewIconCnt : integer;
  public
    { Public declarations }
    TempIconFile : string;
    DrawingTool : TDrawingTools;
    TestColorIndex : integer;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}


procedure TMainForm.ReadIni;
begin
  with TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI')) do
  try
    with MainForm do
    begin
      Width:= ReadInteger('Setup', 'Width', DefaultWidth);
      Height:= ReadInteger('Setup', 'Height', DefaultHeight);
      Top:= ReadInteger('Setup', 'Top',
        (GetSystemMetrics(SM_CYSCREEN) - Height) div 2);
      Left:= ReadInteger('Setup', 'Left',
        (GetSystemMetrics(SM_CXSCREEN) - Width) div 2);
    end;

    ShowPixels.Checked:= ReadBool('Setup', 'Show Pixels', true);
    TestColorIndex:= ReadInteger('Setup', 'Test Color', 7);
  finally
    Free;
  end;
end;

procedure TMainForm.WriteIni;
begin
  with TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI')) do
  try
    if WindowState <> wsMaximized then
    with MainForm do
    begin
      WriteInteger('Setup', 'Width', Width);
      WriteInteger('Setup', 'Height', Height);
      WriteInteger('Setup', 'Top', Top);
      WriteInteger('Setup', 'Left', Left);
    end;

    WriteBool('Setup', 'Show Pixels', ShowPixels.Checked);
    WriteInteger('Setup', 'Test Color', TestColorIndex);
  finally
    Free;
  end;
end;

procedure TMainForm.SaveSpeedButtonClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;
  with TIconForm(ActiveMDIChild) do
  if NewIcon then
    SaveAsClick(Sender)
  else
    SaveIcon(Sender);
end;

function TMainForm.ReadIconFromFile(OpenName, FileName,
  IconName : string; ANewIcon : boolean) : boolean;
var
  NumRead : longint;
  i, ImageCount : integer;
  PIndex : pchar;
begin
  Result:= false;
  with TIconForm.Create(Application) do
  try
    IconFileName:= FileName;
    Caption:= IconName;
    NewIcon:= ANewIcon;

    IconSize:= 32;

    SetupWindow;

    {$I-}
    AssignFile(F, OpenName);
    FileMode:= 0;
    Reset(F, 1);
    {$I+}
    if IOResult <> 0 then
    begin
      Free;
      exit;
    end;

    IconFileSize:= FileSize(F);

    GetMem(IconBuffer, IconFileSize);
    if not assigned(IconBuffer) then
    begin
      Free;
      exit;
    end;

    PIndex:= @IconBuffer[0];
    BlockRead(F, IconBuffer^, IconFileSize, NumRead);
    if (NumRead <> IconFileSize) or
       (NumRead < sizeof(TIconDir)) or
       (PIconDir(PIndex).idReserved <> 0) or
       (PIconDir(PIndex).idType <> 1) then
    begin
      Free;
      exit;
    end;

    ImageCount:= PIconDir(PIndex).idCount;
    PIndex:= @IconBuffer[sizeof(TIconDir)];

    for i:= 0 to ImageCount - 1 do
    begin
      if NumRead < sizeof(TIconDir) + sizeof(TIconDirEntry) * i then
      begin
        Free;
        exit;
      end;

      if (PIconDirEntry(PIndex).bWidth = 32) and
         (PIconDirEntry(PIndex).bHeight = 32) and
         ((PIconDirEntry(PIndex).bColorCount = 16) or
          (PIconDirEntry(PIndex).bColorCount = 4)) and
         (PIconDirEntry(PIndex).bReserved = 0) then
      begin
        PIndex:= @IconBuffer[PIconDirEntry(PIndex).dwImageOffset];
        ImageOffset:= PIndex;

        Move(PIconImage(PIndex).icColors,
             IconColors,
             16 * sizeof(TRGBQuad));

        SetupUndoBuff;

        Result:= true;
        exit;
      end;

      MessageDlg('32x32, 16 color icon not found',
        mtError, [mbOK], 0);
      Free;
    end;
  finally
    CloseFile(F);
  end;
end;

procedure TMainForm.Open1Click(Sender: TObject);
begin
  with OpenDialog1 do
  begin
    FileName:= '';
    if Execute then
      if ExtractFileExt(FileName) <> 'ICO' then
        Import(FileName)
      else
        ReadIconFromFile(FileName,
                         FileName,
                         ExtractFileName(FileName),
                         false);
  end;
  UpdateButtons;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.New1Click(Sender: TObject);
var
  PIndex : pchar;
begin
  with TIconForm.Create(Application) do
  try
    inc(NewIconCnt);
    Caption:= 'Icon' + IntToStr(NewIconCnt) + '.ico';
    IconFileName:= Caption;
    NewIcon:= true;
    IconSize:= 32;

    SetupWindow;

    IconFileSize:= sizeof(TIconDir) +
                   sizeof(TIconDirEntry) +
                   sizeof(TIconImage);

    GetMem(IconBuffer, IconFileSize);
    if not assigned(IconBuffer) then
    begin
      Free;
      exit;
    end;

    PIndex:= @IconBuffer[0];
    PIconDir(PIndex).idReserved:= 0;
    PIconDir(PIndex).idType:= 1;
    PIconDir(PIndex).idCount:= 1;

    PIndex:= @IconBuffer[sizeof(TIconDir)];
    PIconDirEntry(PIndex).bWidth:= 32;
    PIconDirEntry(PIndex).bHeight:= 32;
    PIconDirEntry(PIndex).bColorCount:= 16;
    PIconDirEntry(PIndex).bReserved:= 0;
    PIconDirEntry(PIndex).wPlanes:= 0;
    PIconDirEntry(PIndex).wBitCount:= 0;
    PIconDirEntry(PIndex).dwBytesInRes:= sizeof(TIconImage);
    PIconDirEntry(PIndex).dwImageOffset:= sizeof(TIconDir) +
                                          sizeof(TIconDirEntry);

    PIndex:= @IconBuffer[PIconDirEntry(PIndex).dwImageOffset];
    ImageOffset:= PIndex;

    FillChar(PIconImage(PIndex).icHeader,
             sizeof(PIconImage(PIndex).icHeader),
             0);
    PIconImage(PIndex).icHeader.biSize:= sizeof(TBitMapInfoHeader);
    PIconImage(PIndex).icHeader.biWidth:= 32;
    PIconImage(PIndex).icHeader.biHeight:= 64;
    PIconImage(PIndex).icHeader.biPlanes:= 1;
    PIconImage(PIndex).icHeader.biBitCount:= 4;
    PIconImage(PIndex).icHeader.bisizeimage:= 640;

    Move(DefaultColors,
         PIconImage(PIndex).icColors,
         16 * sizeof(TRGBQuad));

    Move(PIconImage(PIndex).icColors,
               IconColors,
               16 * sizeof(TRGBQuad));

    FillChar(PIconImage(PIndex).icXOR,
             sizeof(TXorMask),
             0);

    FillChar(PIconImage(PIndex).icAND,
             sizeof(TAndMask),
             $FF);

    SetupUndoBuff;

    UpdateButtons;
  finally
  end;
end;

procedure TMainForm.SaveAsClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;
  with SaveDialog1, TIconForm(ActiveMDIChild) do
  begin
    Title:= 'Save ' + IconFileName + ' As';
    FileName:= IconFileName;
    if Execute then
    begin
      NewIcon:= false;
      IconFileName:= FileName;
      Caption:= ExtractFileName(FileName);
      SaveSpeedButtonClick(Sender);
    end;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ReadIni;

  TempIconFile:= ExtractFileDir(Application.ExeName);
  if TempIconFile[length(TempIconFile)] <> '\' then
    TempIconFile:= TempIconFile + '\';
  TempIconFile:= TempIconFile + 'Temp$$$$.ico';

  DrawingTool:= Pencil;
  UpdateTool;

  UpdateButtons;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  WriteIni;
end;

procedure TMainForm.Panel0MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  with Sender as TPanel do
  case Button of
  mbLeft:
    begin
      LeftButtonPanel.Color:= Color;
      LeftButtonPanel.Tag:= Tag;
      with LeftButtonPanel do
      case Tag of
        0 : Caption:= '';
        1 : Caption:= 'T';
        2 : Caption:= 'R';
      end;
    end;
  mbRight:
    begin
      RightButtonPanel.Color:= Color;
      RightButtonPanel.Tag:= Tag;
      with RightButtonPanel do
      case Tag of
        0 : Caption:= '';
        1 : Caption:= 'T';
        2 : Caption:= 'R';
      end;
    end;
  end;
end;

procedure TMainForm.TopicsClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_PARTIALKEY, 0);
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  with TAboutBox.Create(Application) do
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMainForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.Tile1Click(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.Close1Click(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;
  TIconForm(ActiveMDIChild).Close;
  Application.ProcessMessages;
  UpdateButtons;
end;

procedure TMainForm.CloseAll1Click(Sender: TObject);
var
  i : integer;
begin
  if MDIChildCount = 0 then exit;
  for i:= MDIChildCount - 1 downto 0 do
  begin
    if MDIChildCount - 1 <> i then break;
    TIconForm(MDIChildren[i]).Close;
    Application.ProcessMessages;
  end;
  UpdateButtons;
end;

procedure TMainForm.CaptureSpeedButtonClick(Sender: TObject);
begin
  with Sender as TSpeedButton do
    DrawingTool:= TDrawingTools(Tag);

  if MDIChildCount = 0 then exit;

  with TIconForm(ActiveMDIChild) do
  begin
    CapturedDraw;
    IconTool:= DrawingTool;
    UpdateCursor;
  end;
end;

function EnumResName(Module : THandle; ResourceType : pointer;
  ResourceName : pchar; Param : longint) : boolean; StdCall;
var
  hGlobal : THandle;
  lpIconDir, lpIconImage : pchar;
  PIndex : pchar;
begin
  Result:= false;

  hGlobal:= LoadResource(
            Module,
            FindResource(
            Module,
            ResourceName,
            ResourceType));
  if hGlobal = 0 then
  begin
    ShowMessage('Load icon failed');
    exit;
  end;

  lpIconDir:= LockResource(hGlobal);
  if lpIconDir = nil then
  begin
    ShowMessage('Lock icon in memory failed');
    exit;
  end;

  PIndex:= lpIconDir;

  Result:= true;

  if (PIconDir(PIndex).idReserved <> 0) or
     (PIconDir(PIndex).idType <> 1) then
    exit;

  PIndex:= @lpIconDir[sizeof(TIconDir)];

  if (PGrpIconDirEntry(PIndex).bWidth <> 32) or
     (PGrpIconDirEntry(PIndex).bHeight <> 32) or
     ((PGrpIconDirEntry(PIndex).bColorCount <> 16) and
      (PGrpIconDirEntry(PIndex).bColorCount <> 4)) then
    exit;

  Result:= false;

  hGlobal:= LoadResource(
            Module,
            FindResource(
            Module,
            MakeIntResource(PGrpIconDirEntry(PIndex).nID),
            RT_ICON));
  if hGlobal = 0 then
  begin
    ShowMessage('Load icon failed');
    exit;
  end;

  lpIconImage:= LockResource(hGlobal);
  if lpIconImage = nil then
  begin
    ShowMessage('Lock icon in memory failed');
    exit;
  end;

  Result:= true;
  Imported:= true;

  with TIconForm.Create(Application) do
  try
    inc(MainForm.NewIconCnt);
    Caption:= 'Icon' + IntToStr(MainForm.NewIconCnt) + '.ico';
    IconFileName:= Caption;
    NewIcon:= true;
    IconSize:= 32;

    SetupWindow;

    IconFileSize:= sizeof(TIconDir) +
                   sizeof(TIconDirEntry) +
                   sizeof(TIconImage);

    GetMem(IconBuffer, IconFileSize);
    if not assigned(IconBuffer) then
    begin
      Free;
      exit;
    end;

    PIndex:= @IconBuffer[0];
    PIconDir(PIndex).idReserved:= 0;
    PIconDir(PIndex).idType:= 1;
    PIconDir(PIndex).idCount:= 1;

    PIndex:= @IconBuffer[sizeof(TIconDir)];
    PIconDirEntry(PIndex).bWidth:= 32;
    PIconDirEntry(PIndex).bHeight:= 32;
    PIconDirEntry(PIndex).bColorCount:= 16;
    PIconDirEntry(PIndex).bReserved:= 0;
    PIconDirEntry(PIndex).wPlanes:= 0;
    PIconDirEntry(PIndex).wBitCount:= 0;
    PIconDirEntry(PIndex).dwBytesInRes:= sizeof(TIconImage);
    PIconDirEntry(PIndex).dwImageOffset:= sizeof(TIconDir) +
                                          sizeof(TIconDirEntry);

    PIndex:= @IconBuffer[PIconDirEntry(PIndex).dwImageOffset];
    ImageOffset:= PIndex;

    Move(PIconImage(lpIconImage).icHeader,
         PIconImage(PIndex).icHeader,
         sizeof(TIconImage));

    Move(PIconImage(PIndex).icColors,
               IconColors,
               16 * sizeof(TRGBQuad));

    SetupUndoBuff;
  finally
  end;
end;

function TMainForm.Read16BitIcons(P : pchar) : boolean;
var
  N : integer;
  NewIconName : string;
  IH : HIcon;
begin
  Result:= false;
  N:= 0;
  IH:= ExtractIcon(hInstance, P, N);
  while IH <> 0 do
  begin
    with TIcon.Create do
    try
      Handle:= IH;
      SaveToFile(TempIconFile);
    finally
      Free;
    end;

    inc(NewIconCnt);
    NewIconName:= 'Icon' + IntToStr(MainForm.NewIconCnt) + '.ico';
    if not ReadIconFromFile(TempIconFile,
                            NewIconName,
                            NewIconName,
                            true) then
      begin
        DeleteFile(TempIconFile);
        exit;
      end;

    Result:= true;
    DeleteFile(TempIconFile);
    inc(N);
    IH:= ExtractIcon(hInstance, P, N);
  end;
end;

procedure TMainForm.Import(FileName : TFileName);
var
  ModuleName : array[0..255] of char;
  ModuleHandle : THandle;
begin
  StrPCopy(ModuleName, FileName);
  ModuleHandle:= LoadLibraryEx(ModuleName,
                               0,
                               LOAD_LIBRARY_AS_DATAFILE);
  if ModuleHandle = 0 then
  begin
    if not Read16BitIcons(ModuleName) then
    begin
      ShowMessage('Couldn''t load icon. ');
      exit;
    end;
  end
  else
  begin
    Imported:= false;

    if (not EnumResourceNames(
           ModuleHandle,
           RT_GROUP_ICON,
           @EnumResName,
           0)) or
       (Imported = false) then
      ShowMessage('Couldn''t find icon');

    FreeLibrary(ModuleHandle);
  end;
end;

procedure TMainForm.UpdateTool;
begin
  case DrawingTool of
    Capture : CaptureSpeedButton.Down:= true;
    Pencil : PencilSpeedButton.Down:= true;
    Fill : FillSpeedButton.Down:= true;
    Line : LineSpeedButton.Down:= true;
    ClearRectangle : ClearRectangleSpeedButton.Down:= true;
    FilledRectangle : FilledRectangleSpeedButton.Down:= true;
    ClearEllipse : ClearEllipseSpeedButton.Down:= true;
    FilledEllipse : FilledEllipseSpeedButton.Down:= true;
  end;
end;

procedure TMainForm.UpdateButtons;
begin
  Save.Enabled:= MDIChildCount > 0;
  SaveSpeedButton.Enabled:= Save.Enabled;
  SaveAs.Enabled:= Save.Enabled;
  Close1.Enabled:= Save.Enabled;
  CloseAll1.Enabled:= Save.Enabled;
end;

procedure TMainForm.File1Click(Sender: TObject);
begin
  UpdateButtons;
end;

procedure TMainForm.Edit1Click(Sender: TObject);
begin
  Undo.Enabled:= false;
  Cut.Enabled:= false;
  Copy.Enabled:= false;
  Paste.Enabled:= false;
  SelectAll.Enabled:= false;
  TestIcon.Enabled:= false;

  if MDIChildCount = 0 then exit;

  with TIconForm(ActiveMDIChild) do
  begin
    Undo.Enabled:= UndoCount > 0;
    Cut.Enabled:= Captured;
  end;

  Copy.Enabled:= Cut.Enabled;
  Paste.Enabled:= Clipboard.HasFormat(CF_DIB);
  SelectAll.Enabled:= true;
  TestIcon.Enabled:= true;
end;

procedure TMainForm.UndoClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).PreviousUndo;
end;

procedure TMainForm.CutClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).CutCaptured;
end;

procedure TMainForm.CopyClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).CopyCaptured;
end;

procedure TMainForm.PasteClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).Paste;
end;

procedure TMainForm.SelectAllClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).SelectAll;
end;

procedure TMainForm.ShowPixelsClick(Sender: TObject);
var
  i : integer;
begin
  ShowPixels.Checked:= not ShowPixels.Checked;
  for i:= 0 to MDIChildCount - 1 do
    TIconForm(MDIChildren[i]).FormPaint(Sender);
end;


procedure TMainForm.TestIconClick(Sender: TObject);
begin
  if MDIChildCount = 0 then exit;

  TIconForm(ActiveMDIChild).TestIcon(Sender);
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  if Width < DefaultWidth then
    Width:= DefaultWidth;
  if Height < DefaultHeight then
    Height:= DefaultHeight;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
  FileName : TFileName;
  i : integer;
begin
  for i:= 1 to ParamCount do
  begin
    FileName:= ParamStr(i);
    if ExtractFileExt(FileName) <> 'ICO' then
      Import(FileName)
    else
      ReadIconFromFile(FileName,
                       FileName,
                       ExtractFileName(FileName),
                       false);
  end;

  UpdateButtons;
end;


end.
