<html>
<head>
  <title>PHP Weather</title>
</head>
<body>

<?php
/* 	$Id: demo.php,v 1.33 2000/11/27 07:53:02 gimpster Exp gimpster $	 */
/* Be sure to check out the newest version from http://www.gimpster.com */
include('locale_en.inc');
include('phpweather.inc');

$metar = get_metar('EKYT');
?>

<h1><a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a></h1>
<p><a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> is a script written in <a href="http://www.gimpster.com/php/index.php">PHP</a>, that will decode a <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> weather report. Every hour a round the clock airports make a <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a>-report where they measure things like the temperature, the wind speed and direction etc. This information is available on the Internet <a href="http://weather.noaa.gov/weather/ccworld.html">here</a>. Choose a country and then a observing location and you'll get the latest report. It even caches the <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METARs</a> in a database so subsequent request for the same station will be served as fast as possible.</p>

<p>But the report is not just saved in plain-text. Its coded in a special <a href="http://tgsv5.nws.noaa.gov/oso/oso1/oso12/fmh1/fmh1ch12.htm">code</a>, so it has to be decoded before you can use it. This is what <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> is for, decoding a <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> into plain-text, so you can use for something useful.</p>

<h1>Your version: <? echo $version ?></h1>
<p>Your source was last modified at <b><? echo $last_modified ?> UTC</b>. Click <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">here</a> to download the newest version from <a href="http://www.gimpster.com">gimpster.com</a>. If you are having problems with <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a>, then please upgrade to the latest version. If that doesn't help, then ask for help at the maillinglist, by sending a mail to <a href="mailto:phpweather@gimpster.com">phpweather@gimpster.com</a>. To receive the answer you have to subscribe by sending a mail to this address: <a href="mailto:phpweather-subscribe@gimpster.com">phpweather-subscribe@gimpster.com</a></p>

<h1>A sample <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a>-report</h1>
<p>The report below is the latest from Aalborg, Denmark (this is where I live). The raw <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> looks this way:</p>

<blockquote><code><? echo $metar ?></code></blockquote>

<p>Not exactly a pretty sight? Well by using <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> you could also present the information like this:</p>

<?
pretty_print_metar($metar, 'Aalborg, Denmark')
?>

<p>Here is the same piece of text with the current weather in
Honolulu, Hawaii. This time the information is presented in
Spanish. First comes the raw <a
href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a>:</p>

<blockquote><code><? echo $metar = get_metar('PHNL') ?></code></blockquote>

<p>and then the pretty-printed output:</p>

<?
include('locale_es.inc');
pretty_print_metar($metar, 'Honolulu, Hawaii');
?>

<p>The only thing I changed between the two pieces of code was the identifier of the weather station, and the include-file with the strings used by <a href="/downloads/phpweather.tar.gz">PHP Weather</a>. The identifier for Aalborg, Denmark is <code>EKYT</code> and the one for Honolulu, Hawaii is <code>PHNL</code>.</p>

<p>Try it out for yourself - choose a city and a language from the lists and you'll see the current weather for the city you selected:<br>
<form action="demo.php" method="post">
<select name="city" onChange="this.form.submit()">
<? 

$cities = array(
  'BGTL' => 'Thule A. B., Greenland',
  'EGKK' => 'London / Gatwick Airport, United Kingdom',
  'EKCH' => 'Copenhagen / Kastrup, Denmark',
  'ENGM' => 'Oslo / Gardermoen, Norway',
  'ESSA' => 'Stockholm / Arlanda, Sweden',
  'FCBB' => 'Brazzaville / Maya-Maya, Congo',
  'LEMD' => 'Madrid / Barajas, Spain',
  'LFPB' => 'Paris / Le Bourget, France',
  'LIRA' => 'Roma / Ciampino, Italy',
  'KNYC' => 'New York City, Central Park, NY, United States',
  'NZCM' => 'Williams Field, Antarctic',
  'UUEE' => 'Moscow / Sheremet\'Ye , Russian Federation',
  'RKSS' => 'Seoul / Kimp\'O International Airport, Korea',
  'YSSY' => 'Sydney Airport, Australia',
  'ZBAA' => 'Beijing, China'
  );

while (list($icao, $location) = each($cities)) {
  if ($icao == $city) {
    echo "<option selected value=\"$icao\">$location</option>\n";
  } else {
    echo "<option value=\"$icao\">$location</option>\n";
  }
} ?>
</select>
<select name="language" onChange="this.form.submit()">
<?
$languages = array(
  'po_br' => 'Brazilian Portuguese',
  'cz' => 'Czech',
  'da' => 'Danish',
  'nl' => 'Dutch',
  'en' => 'English',
  'fr' => 'French',
  'de' => 'German',
  'es' => 'Spanish',
  'no' => 'Norwegian'
  );

while (list($lang_code, $locale) = each($languages)) {
  if ($lang_code == $language) {
    echo "<option selected value=\"$lang_code\">$locale</option>\n";
  } else {
    echo "<option value=\"$lang_code\">$locale</option>\n";
  }
} ?>
</select>
</form></p>

<?
if (!isset($city)) {
  $city = 'BGTL';
  $language = 'en'; 
}
$metar = get_metar($city);
include('locale_' . $language . '.inc');
pretty_print_metar($metar, $cities[$city]) ?>
<p>The <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> for <? echo $cities[$city] ?>, presented in <? echo $languages[$language] ?>, was:</p>
<blockquote><code><? echo $metar ?></code></blockquote>


<h1>Using PHP Weather</h1>
<p>Using <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> is very simple. You can see how I've made this page by taking a look at the <a href="http://www.gimpster.com/showsource.php?file=<? echo rawurlencode($PHP_SELF) ?>">source</a>. First you have to include the file <code>phpweather.inc</code> in your page. Then you call the function <code>get_metar($station)</code> with the four-character station-identifier. This gives you the <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a>, which you can then feed to <code>process_metar($metar)</code>. This function return an array that contains the various parts of the <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> in decoded form. They are also returned in both empirical (feet, miles, degrees of Fahrenheit, etc.) and metric units (meters, kilometers and degrees Celsius).</p>
<p>This code is all that is <i>necessary</i> to make <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> work:</p>

<code><font color="#000000">
<font color="#0000BB">&lt;?php<br></font><font color="#007700">include(</font><font color="#DD0000">'locale_en.inc'</font><font color="#007700">);<br>include(</font><font color="#DD0000">'phpweather.inc'</font><font color="#007700">);<br></font><font color="#0000BB">$metar&nbsp;</font><font color="#007700">=&nbsp;</font><font color="#0000BB">get_metar</font><font color="#007700">(</font><font color="#DD0000">'EKYT'</font><font color="#007700">);<br></font><font color="#0000BB">$data&nbsp;</font><font color="#007700">=&nbsp;</font><font color="#0000BB">process_metar</font><font color="#007700">(</font><font color="#0000BB">$metar</font><font color="#007700">);<br></font><font color="#0000BB">$temp&nbsp;</font><font color="#007700">=&nbsp;</font><font color="#0000BB">$data</font><font color="#007700">[</font><font color="#DD0000">'temp_c'</font><font color="#007700">];<br>echo&nbsp;</font><font color="#DD0000">"The&nbsp;temperature&nbsp;is&nbsp;$temp&nbsp;degrees&nbsp;Celsius."</font><font color="#007700">;<br></font><font color="#0000BB">?&gt;<br></font>
</font>
</code>

<p>That's it! The above code will tell you what the temperature is in
Aalborg, Denmark. To make the examples above I've made a function
called <code>pretty_print_metar()</code>. You use it like this:</p>

<code><font color="#000000">
<font color="#0000BB">&lt;?php<br>$metar&nbsp;</font><font color="#007700">=&nbsp;</font><font color="#0000BB">get_metar</font><font color="#007700">(</font><font color="#DD0000">'EKYT'</font><font color="#007700">);<br></font><font color="#0000BB">pretty_print_metar</font><font color="#007700">(</font><font color="#0000BB">$metar</font><font color="#007700">,&nbsp;</font><font color="#DD0000">'Aalborg,&nbsp;Denmark'</font><font color="#007700">);<br></font><font color="#0000BB">?&gt;<br></font>
</font>
</code>

<h1>Caching the <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METARs</a></h1>
<p>But you'll soon start to look for a way to improve the response-time of your script. To do this, you first have to decide what database you want to use. You have the choice of setting up a a <a href="http://www.mysql.com">MySQL</a>, <a href="http://www.postgresql.org/">PostgreSQL</a> or a DBM database. You have to edit <code>phpweather.inc</code> to choose the database, just set the appropriate variable to 1 (<code>$useMySQL</code>, <code>$useDBM</code> or <code>$usePSQL</code>).</p>
<p>If you choose to use <a href="http://www.mysql.com">MySQL</a>, then create a table called <code>metars</code> with the following create-information:</p>
<pre>
CREATE TABLE metars (
  metar VARCHAR(255) NOT NULL,
  timestamp TIMESTAMP(14),
  station VARCHAR(4) NOT NULL,
  PRIMARY KEY (station),
  UNIQUE station (station)
);
</pre>
<p>If you wan to use a <a href="http://www.postgresql.org/">PostgreSQL</a> database, then create the table this way:</p>
<pre>
CREATE TABLE metars (
  metar VARCHAR(255) NOT NULL,
  timestamp TIMESTAMP,
  station VARCHAR(4) PRIMARY KEY NOT NULL
);
</pre>
<p>Remember that you have to connect to the database by commenting-out the code found in <code>phpweather.inc</code>.</p>
<p>If you don't do this, you'll recieve a lot of errors, saying things like: &quot;<code>MySQL Connection Failed: Access denied for user: 'nobody@localhost' (Using password: NO) in phpweather.inc</code>&quot; and &quot;<code>Supplied argument is not a valid MySQL result resource in phpweather.inc</code>&quot;. These errors are trying to tell you, that <a href="/downloads/phpweather.tar.gz">PHP Weather</a> couldn't store the <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> in the <a href="http://www.mysql.com">MySQL</a>-database, because you didn't supply a valid username and password.</p>
<p>If you want to use a DBM database, then all you need to do, is to make sure that the user running the webserver has write-permission to the current directory.</p>
<p><a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> will then store the retrieved <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METARs</a> in the database, and use the cached <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> if it's less that 1 hour old. If it's older, it is expected that the station has made a new observation, so we should update our data.</p>

<p class="section">Using <a href="/downloads/phpweather.tar.gz">PHP Weather</a> with <a href="http://www.wapforum.org/">WAP</a></p>
<p><a href="/downloads/phpweather.tar.gz">PHP Weather</a> can also be used to serve current weather information to <a href="http://www.wapforum.org/">WAP</a>-enables mobile phones. To do this, just put the file <code>wap.php</code> in the same directory as <code>phpweather.inc</code> and then point your <a href="http://www.wapforum.org/">WAP</a>-browser on your mobile phone to the page. It should then show you the current weather in Aalborg, Denmark.</p>
<p>The format used in the <code>wap.php</code>-page is a smaller and more compact format than the one shown on this page. It looks like this:</p>
<pre><? pretty_print_metar_wap(get_metar('EKYT'), 'Aalborg'); ?></pre>

<h1>Related information</h1>
<dl>
<dt><a href="http://tgsv5.nws.noaa.gov/oso/oso1/oso12/fmh1/fmh1ch12.htm">Federal Meteorological Handbook No. 1, Chapter 12 Coding</a></dt>
<dd><p>This is the official specification on the METAR-encoding scheme. If you want to learn how to read the raw coded messages, or want to make a parser yourself, you should read this. It might seam a bit complicated at first sight, but when you've read it a couple of times things start to clear up :-)</p></dd>
<dt><a href="http://www.wcnet.org/~jzawodn/perl/Geo-METAR/">Geo::METAR</a></dt>
<dd><p><a href="http://www.wcnet.org/~jzawodn/perl/Geo-METAR/">Geo::METAR</a> is written by <a href="mailto:Jeremy@Zawodny.com">Jeremy D. Zawodny</a>, and is the <a href="http://www.perl.com">Perl</a> module that I used as a template for <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a>. I searched the web for a <a href="http://www.gimpster.com/php/index.php">PHP</a>-script that could translate a <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a>, but instead I found <a href="http://www.wcnet.org/~jzawodn/perl/Geo-METAR/">Geo::METAR</a>. When looking at the <a href="http://www.perl.com">Perl</a>-code I realised that I could just translate the <a href="http://www.perl.com">Perl</a>-code into <a href="http://www.gimpster.com/php/index.php">PHP</a>-code. So I did, and the result is <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a>.</p></dd>
<dt><a href="http://weather.noaa.gov/weather/metar.shtml">METAR Data Access</a></dt>
<dd><p>Here you'll find the raw <a href="http://www.nws.noaa.gov/oso/oso1/oso12/metar.htm">METAR</a> data. In <a href="http://www.gimpster.com/downloads/phpweather.tar.gz">PHP Weather</a> I download the reports from <a href="http://weather.noaa.gov/pub/data/observations/metar/stations/">http://weather.noaa.gov/pub/data/observations/metar/stations/</a>.</p>
<p>To use any of these services you have to know the four-character ICAO Location Indicator for the station. The easiest way to find the Location Indicator is to go to <a href="http://weather.noaa.gov/weather/ccworld.html">this</a> page. There you'll be able to choose a country, and the choose a station from a list of stations is that country.</p></dd>
</dl>
</body>
</html>
