<?php
///////////////////////////////////////////////////////////////////////////////
// File: create_admin.php
// Purpose: allows creation of another admin account
// Remarks: requires common.php
///////////////////////////////////////////////////////////////////////////////
// Functions:
//		void display_form(array)
//		array check_form()
//		void add_admin()
///////////////////////////////////////////////////////////////////////////////

require("./common.php");

session_start();

///////////////////////////////////////////////////////////////////////////////
// Function: void display_form(array $err)
// Purpose: displays form for admin account creation
// Parameters:
//		$err - array containing erroroneous fields and error messages
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
//		$HTTP_SESSION_VARS
///////////////////////////////////////////////////////////////////////////////
function display_form($err=array())
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;
	global $HTTP_SESSION_VARS;

	$sitename=$GLOBALS['sitename'];
	$admin_table=$GLOBALS['admin_table'];

	pageheader("$sitename - Create another admin account","onLoad=\"document.forms['add_admin_form'].elements['new_userid'].focus()\"");
?>
<div align="center">
<h1>Create another admin account</h1>
<?php
if(count($err))
// error in previous submission
{
	echo "<span class=\"error\">There was an error in your previous submission. Please re-enter the fields highlighted in red.</span>\n";
}
?>

<form name="add_admin_form" method="post" action="<?=$PHP_SELF?>">
<input name="action" type="hidden" value="add_admin">

<!-- form table -->
<table width="<?=$GLOBALS['OB_table_width']?>" cellspacing="1" cellpadding="5">
	<tr>
		<th align="right"><?php if(in_array("new_userid",$err)) echo "<span class=\"error\">"; ?>New account User ID:<?php if(in_array("new_userid",$err)) echo "</span>"; ?></th>
		<td>
			<input name="new_userid" type="text" value="<?php if(isset($HTTP_POST_VARS['new_userid'])) echo $HTTP_POST_VARS['new_userid'];?>" size="12" maxlength="12">
			<br />4-12 alphanumeric characters (no duplicate User IDs allowed)
		</td>
	</tr>
	<tr>
		<th align="right"><?php if(in_array("new_email",$err)) echo "<span class=\"error\">"; ?>Email address:<?php if(in_array("new_email",$err)) echo "</span>"; ?></th>
		<td><input name="new_email" type="text" value="<?php if(isset($HTTP_POST_VARS['new_email'])) echo $HTTP_POST_VARS['new_email'];?>" size="30" maxlength="40"><br />Enter a valid email to receive notification when guestbook is signed</td>
	</tr>
	<tr>
		<th align="right"><?php if(in_array("new_password1",$err)) echo "<span class=\"error\">"; ?>Password:<?php if(in_array("new_password1",$err)) echo "</span>"; ?></th>
		<td>
			<input name="new_password1" type="password" size="12" maxlength="12">
			<br />4-12 alphanumeric characters
		</td>
	</tr>
	<tr>
		<th align="right"><?php if(in_array("new_password2",$err)) echo "<span class=\"error\">"; ?>Re-enter Password:<?php if(in_array("new_password2",$err)) echo "</span>"; ?></th>
		<td><input name="new_password2" type="password" size="12" maxlength="12"></td>
	</tr>
	<tr>
		<td class="buttons" colspan="2" align="right"><input type="submit" value="Create admin account"> <input type="reset" value="Reset"></td>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">
			Back to <a href="./index.php">Guestbook</a> | <a href="./admin.php">Admin Panel</a>
		</td>
	</tr>
</table>
<!-- END form table -->

</form>
<?php
	db_connect();

	$query="SELECT userid,email FROM $admin_table";
	$result=mysql_query($query);
	$num_admin=mysql_num_rows($result);		// number of admin accounts

	echo "There ";
	if($num_admin >1) echo "are"; else echo "is";
	echo " currently <b>".$num_admin."</b> existing admin account";
	if($num_admin > 1) echo "s."; else echo ".";
	echo "<br />\n";

	while($row=mysql_fetch_array($result))
	{
		if($row['userid']==$HTTP_SESSION_VARS['admin_name'])
		{
			echo "<b>".$row['userid']." - ".$row['email']."</b><br />\n";
		}
		else
		{
			echo $row['userid']." - ".$row['email']. "<br />\n";
		}
	}
?>
</div>
<?php
}// end display_form()

///////////////////////////////////////////////////////////////////////////////
// Function: array check_form()
// Purpose: checks form fields for errors; returns array containing errorneous fields
// Parameters: none
// Returns: nothing
// Global references:
//		$HTTP_POST_VARS
///////////////////////////////////////////////////////////////////////////////
function check_form()
{
	global $HTTP_POST_VARS;

	$err=array();		//  array for storing erroroneous fields and error messages

	if(empty($HTTP_POST_VARS['new_userid']) || !ereg('^[0-9A-Za-z]{4,12}$',$HTTP_POST_VARS['new_userid']))
	// userid cannot be empty and must be between 4-12 characters
	{
		$err[]="new_userid";
	}
	else
	// check if userid already exists in database
	{
		db_connect();
		$query="SELECT userid FROM {$GLOBALS['admin_table']}";
		$result=mysql_query($query);
		while($row=mysql_fetch_array($result))
		{
			if($HTTP_POST_VARS['new_userid'] == $row['userid'])
			{
				$err[]="new_userid";
				break;
			}
		}
	}
	if(empty($HTTP_POST_VARS['new_email']) || !ereg('^[0-9A-Za-z]+[\._0-9A-Za-z]*@([0-9A-Za-z-]+\.)+([0-9A-Za-z]){2,6}$',$HTTP_POST_VARS['new_email']))
	// check email field format
	{
		$err[]="new_email";
	}
	if(empty($HTTP_POST_VARS['new_password1']))
	{
		$err[]="new_password1";
	}
	if(empty($HTTP_POST_VARS['new_password2']))
	{
		$err[]="new_password2";
	}
	if(!($HTTP_POST_VARS['new_password1'] == $HTTP_POST_VARS['new_password2']) || !ereg('^[0-9A-Za-z]{4,12}$',$HTTP_POST_VARS['new_password1']))
	// both password fields do not match match OR 
	// format of password is not alphanumeric and 4-12 characters
	{
		$err[]="new_password1";
		$err[]="new_password2";
	}

	return $err;
}// end check_form()

///////////////////////////////////////////////////////////////////////////////
// Function: void add_admin()
// Purpose: attempts creation of admin account
// Parameters: none
// Returns: nothing
// Global references:
//		$PHP_SELF
//		$HTTP_POST_VARS
///////////////////////////////////////////////////////////////////////////////
function add_admin()
{
	global $PHP_SELF;
	global $HTTP_POST_VARS;

	$sitename=$GLOBALS['sitename'];
	$admin_table=$GLOBALS['admin_table'];

	$post=$HTTP_POST_VARS;	// alias for $HTTP_POST_VARS

	$err=array();		// array for storing erroroneous fields and error messages

	$err=check_form();	// check form inputs for errors

	if(count($err))
	// display form again together with error messages
	{
		pageheader("$sitename - Error in form...");

		display_form($err);
	}
	else
	{
		db_connect();

		$query="INSERT INTO $admin_table VALUES('$post[new_userid]',password('$post[new_password1]'),'$post[new_email]')";
		$result=mysql_query($query);

		// display success/failure of creation of new record
		if(!$result)
		{
			pageheader("$sitename - Error processing your entry...");
			die("There has been an error creating the new admin account.<br />If this error persists, please contact the developers at the <a href=\"http:\\openbook.sourceforge.net\">OpenBook website</a>.");
		}
		else
		{
			pageheader("$sitename - Admin Account Created");
?>
<div align="center">
<h1>New Account Created</h1>
A new admin account has been created.
<br />
A comfirmation email containing the password has also been emailed to the new account.
<br /><br />
<table width="<?=$GLOBALS[OB_table_width]?>" cellspacing="1" cellpadding="5">
	<tr>
		<th align="right" width="30%">User ID:</th>
		<td><?=$post['new_userid']?></td>
	</tr>
	</tr>
		<th align="right" width="30%">Email address:</th>
		<td><?=$post['new_email']?></td>
	</tr>
	<tr>
		<td class="links" colspan="2" align="right">
			Back to <a href="./index.php">Guestbook</a> | <a href="./admin.php">Admin Panel</a>
		</td>
	</tr>
</table>
</div>
<?php
			// mail confirmation of creation to email accounts of creator and new account
			$mail_to="$post[new_email]";
			$mail_subject="Your account has been created!";
			$mail_body="Your OpenBook administration account has been successfully created.\n\n";
			$mail_body.="User ID: $post[new_userid]\n";
			$mail_body.="Password: $post[new_password1]\n\n";
			$mail_body.="From the OpenBook auto-mailer";
			$mail_headers="From: OpenBook Mailer <no-reply@openbook.mailer>\n";
			$mail_headers.="X-Mailer: OpenBook Mailer";

			// send comfirmation email to new account
			mail($mail_to, $mail_subject, $mail_body, $mail_headers);
		}
	}
}// end add_admin()


///////////////////////////////////////////////////////////////////////////////
// script main
///////////////////////////////////////////////////////////////////////////////
if(isset($HTTP_SESSION_VARS['admin_name']))
// IMPT: check if user is administrator first
{
	if(isset($HTTP_POST_VARS['action']) && $HTTP_POST_VARS['action'] == "add_admin")
	// process confirmation of admin account creation
	{
		add_admin();
	}
	else if(isset($HTTP_GET_VARS['action']) && $HTTP_POST_VARS['action'] == "delete")
	{
		delete_admin();
	}
	else
	// $action not 'add_admin'; display form for admin account creation
	{
		display_form();
	}
}
else
// user is NOT logged in as administrator
{
	not_logged_error();
}

pagefooter();
?>