<?
/*
* LINEGRAPH.PHP3
* Lauren D. Stegman
* University of Michigan
* 03/20/00
* =====================================================================================================================
* Draws a scatter and line plot in GIF format of a result set from a database query. 
* Use in HTML/PHP3 page as follows  (replace square brackets and square bracketed text with values or variables):
* 	<IMG SRC="linegraph.php3?data=[Query Result]&dx=[width of GIF]&dy=[width of GIF]&ylabel=[text for y-axis label]&xlabel=[text for x-axis label]">
* The Query Result should be an Array with the following structure:
* 	Keys  == >  X-Values
* 	Values ==> Y-Values
* 	eg,  $data = array("X1"=>Y1, "X2"=>Y2, "X3"=>Y3, ...);
* THE DATA ARRAY MUST BE SERIALIZED AND BASE64 ENCODED BEFORE BEING PASSED TO THE SRC ATTRIBUTE OF THE IMG TAG AS FOLLOWS:
* 	$data  = base64_encode(serialize($data));
* THE AXIS LABELS MUST BE URLENCODED AS FOLLOWS PRIOR TO INCLUSION IN THE IMG TAG:
	$xaxis = urlencode("x-axis label"); 
* The data input array, need not be a result from a database.  Obviously, it can be any array generated by any means, along as it is in the proper format.
* =====================================================================================================================
*/

//  Include Files.
require("numPHP/pkg.stats.php");	// Numeric functions used in graph calulations.

// Sample Data
// Uncomment the line below to produce a sample graph without inputting a database query result.
//$data = base64_encode(serialize(array("10"=>20, "50"=>60, "37.5"=>87.5, "120"=>100)));
$array = unserialize(base64_decode($data));

// Sort Array by Key
uksort($array,fsort);		// Sort the input data array by key, eg. x-values.  Requires fsort definition in pkg.stats.php.

//  Make GIF Header
Header( "Content-type: image/gif");
$im = imagecreate($dx,$dy);		// $dx = width of gif, $dy = height of gif

// User-defined chart size/layout variables.
$chartarea = 0.65;			// Defines percentage area of the gif that will make up the actual plot, not including tick, tick labels, and axis labels.
$symbolsize=0.025;		// Defines the size of scattergram symbols, eg 0.025 = 2.5% the width of the GIF.
$numticy = 10;			// $numticy = Number of major tics on the y-axis.
$numticx = 10;			// $numticx = Number of major tics on the x-axis.

//  Calculate main chart size/layout variables.
$wc = $chartarea*$dx;		// $wc = width of chart
$hc = $chartarea*$dy;		// $hc = height of chart
$symbolsize=$symbolsize*$dx;	// Makes the size of scattergram symbols 2.5% the width of the GIF.
$scx = (1-$chartarea-0.1)*$dx;	// $scx = x-coordinate of top-left corner of chart
$scy = 0.1*$dy;			// $scy = y-coordinate of top-left corner of chart
$ecx = 0.9*$dx;			// $ecx = x-coordinate of bottom-right corner of chart
$ecy = ($chartarea+0.1)*$dy;	// $ecy = y-coordinate of bottom-right corner of chart
$ymax=max($array);		// $ymax = maximum y-value in dataset, eg. max value of input array.  Used for maximum tick of y-axis.
$ymin=min($array);		// $ymin = minimum y-value in dataset, eg. min value of input array.  Used for minimum tick of y-axis.
$dyunits=$ymax-$ymin;		// $dyunits = Range of y-values in dataset, eg. range of values in the input array.
$numticy = (int)$numticy-1;		// Subtract 1 from the number of tics to make the math work out correctly below in the tic-building loops.
$dyticlabel=$dyunits/$numticy;	// $dyticlabel = Step size between major tics on y-axis, eg. put tic every 10 units from 10 to 100.
$dytic = $hc/$numticy;		// $dytic = Pixels per unit on the y-axis.
$xmax=fmax($array, $histo = "histo");
$xmin=fmin($array, $histo = "histo");
$dxunits=$xmax-$xmin;
$numticx = (int)$numticx-1;
$dxticlabel=$dxunits/$numticx;
$dxtic = $wc/$numticx;

// Define colors
$black = ImageColorAllocate($im, 0,0,0);
$axiscolor = ImageColorAllocate($im, 0,0,0);
$white = ImageColorAllocate($im, 255,255,255);

// Begin Layout
ImageFilledRectangle($im,0,0,$dx,$dy,$white);		// Create the background for the gif.
ImageLine($im,$scx,$scy,$scx,$ecy,$axiscolor);	// Draw y-axis
ImageLine($im,$scx,$ecy,$ecx,$ecy,$axiscolor);	// Draw x-axis

// Draw y-ticks and tick labels
$yticlabel=$ymax;			
$y=$scy;
$xstartextreme=0;	
for ($i=$numticy; $i >= 0; $i--) {
	ImageLine($im,$scx,$y,$scx-0.025*$wc,$y,$axiscolor);
	$size = ImageTTFBBox($dx*0.05,0, "/fonts/ARIAL.TTF",number_format($yticlabel,0));
	$TicLabelDx = abs($size[2]-$size[0]);
	$TicLabelDy = abs($size[5]-$size[3]);
	$xstart=$scx-0.06*$wc-$TicLabelDx;
	ImageTTFText($im, $dx*0.05, 0, $xstart, $y+$TicLabelDy/2, $black,  "/fonts/ARIAL.TTF", number_format($yticlabel,0));
	if ($xstart > $xstartextreme) { $xstartextreme = $xstart; }
	$y = $y + $dytic;
	$yticlabel=$yticlabel-$dyticlabel;
}
// Draw y-axis label.
$size = ImageTTFBBox($dx*0.06,90, "/fonts/ARIAL.TTF",$ylabel);
$LabelDy = abs($size[3]-$size[1]);
$LabelDx = abs($size[4]-$size[0]);
$diff = ($hc-$LabelDy)/2;
ImageTTFText($im, $dx*0.06, 90, $xstartextreme-$dx/40-$LabelDx,$ecy-$diff, $black,  "/fonts/ARIAL.TTF", $ylabel);

// Draw x-ticks and tick labels.
$xticlabel=$xmax;
$x=$ecx;
$ystartextreme=0;
for ($i=$numticx; $i >= 0; $i--) {
	ImageLine($im,$x,$ecy,$x,$ecy+0.025*$hc,$axiscolor);
	$size = ImageTTFBBox($dy*0.05,-60, "/fonts/ARIAL.TTF",number_format($xticlabel,0));
	$TicLabelDx = abs($size[2]-$size[0]);
	$TicLabelDy = abs($size[5]-$size[3]);
	$ystart=$ecy+0.06*$hc+$TicLabelDy;
	ImageTTFText($im, $dy*0.05, -60, $x-$TicLabelDx/2, $ystart, $black,  "/fonts/ARIAL.TTF", number_format($xticlabel,0));
	if ($ystart > $ystartextreme) { $ystartextreme = $ystart; }
	$x = $x - $dxtic;
	$xticlabel=$xticlabel-$dxticlabel;
}
// Draw x-axis label.
$size = ImageTTFBBox($dy*0.06,0, "/fonts/ARIAL.TTF",$xlabel);
$LabelDx = abs($size[2]-$size[0]);
$LabelDy = abs($size[5]-$size[1]);
$diff = ($wc-$LabelDx)/2;
ImageTTFText($im, $dy*0.06, 0,$scx+$diff, $ystartextreme+$dy/15+$LabelDy, $black,  "/fonts/ARIAL.TTF", $xlabel);

// Plot data.
$lastx=$scx;
$lasty=$ecy;
$xunit=$wc/$dxunits;
$yunit=$hc/$dyunits;
while (list($x, $y) = each($array)) {
$x = (((double) $x*$xunit )+ $scx - ($xunit*$xmin));
$y = $ecy + ($yunit*$ymin) - ((double) $y*$yunit); 
ImageFilledRectangle($im,(double) $x, (double) $y, (double) $x+ $symbolsize,(double) $y+$symbolsize,$black);
ImageLine($im,(double) $lastx, (double) $lasty, (double) $x, (double) $y,$black);;
$lastx=$x;
$lasty=$y;
}

ImageGif($im);
ImageDestroy($im);
?>